# 画面設計書 54-kubeadm completion

## 概要

本ドキュメントは、kubeadmツールの `kubeadm completion` コマンドに関する画面設計書である。bashおよびzshシェルにおけるkubeadmコマンドの補完コードを生成・出力する。

### 本画面の処理概要

`kubeadm completion` コマンドは、指定されたシェル（bashまたはzsh）に対応するkubeadmコマンドの自動補完コードを標準出力に出力するCLIコマンドである。出力されたコードをシェルで評価（source）することで、kubeadmコマンドの対話的な補完機能が利用可能となる。

**業務上の目的・背景**：Kubernetesクラスターの管理において、kubeadmコマンドの正確な入力は重要であるが、サブコマンドやフラグが多岐にわたるため、手動入力は煩雑である。シェル補完を設定することで、Tabキーによるコマンド・サブコマンド・フラグの自動補完が利用可能となり、運用効率と入力正確性が大幅に向上する。本コマンドは、補完スクリプトの生成を自動化し、シェル環境への組み込みを容易にする。

**画面へのアクセス方法**：ターミナル上で `kubeadm completion bash` または `kubeadm completion zsh` を実行する。出力を `source` コマンドやプロファイルファイルに組み込んで使用する。

**主要な操作・処理内容**：
1. `kubeadm completion bash` - bash用の補完コードを出力
2. `kubeadm completion zsh` - zsh用の補完コードを出力
3. `source <(kubeadm completion bash)` - bash補完をその場でロード
4. `kubeadm completion bash > ~/.kube/kubeadm_completion.bash.inc` - ファイルに保存して永続化

**画面遷移**：本コマンドは単独実行のコマンドであり、他のコマンドへの遷移はない。生成された補完コードは、以後のシェルセッションでkubeadmの全サブコマンドの補完に使用される。

**権限による表示制御**：特になし。権限に依存しない。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 118 | クラスター初期化（init） | 補助機能 | kubeadmコマンドのシェル補完コードを出力する |

## 画面種別

CLIコマンド（シェル補完コード生成）

## URL/ルーティング

```
kubeadm completion SHELL
```

## 入出力項目

| 項目名 | 入出力 | 必須 | 型 | デフォルト値 | 説明 |
|--------|--------|------|-----|-------------|------|
| SHELL (引数) | 入力 | 必須 | string | - | 補完コードを生成するシェルの種類。`bash` または `zsh` を指定 |
| 補完コード | 出力 | - | text (シェルスクリプト) | - | 指定シェル用の補完コード |

## 表示項目

| 項目名 | 説明 |
|--------|------|
| ボイラープレート | Apache License 2.0のライセンスヘッダーコメント |
| 補完コード（bash） | cobraフレームワークが生成するbash用補完スクリプト |
| 補完コード（zsh） | bash補完コードをzshで利用可能にするための互換レイヤー + bash補完コード |

## イベント仕様

### 1-kubeadm completion bash 実行

1. `RunCompletion()` が呼び出される
2. 引数の数を検証（1つであること）
3. `completionShells` マップから `bash` に対応する関数 `runCompletionBash` を取得
4. ボイラープレート（ライセンスヘッダー）を出力
5. `kubeadm.GenBashCompletion(out)` を呼び出し、cobraが生成するbash補完コードを出力

### 2-kubeadm completion zsh 実行

1. `RunCompletion()` が呼び出される
2. 引数の数を検証（1つであること）
3. `completionShells` マップから `zsh` に対応する関数 `runCompletionZsh` を取得
4. ボイラープレート（ライセンスヘッダー）を出力
5. zsh互換レイヤーの初期化コードを出力（`__kubeadm_bash_source`, `__kubeadm_type`, `__kubeadm_compgen` 等のzsh互換関数群）
6. `kubeadm.GenBashCompletion(buf)` でbash補完コードを生成
7. bash補完コードをzsh用にsedで変換する `__kubeadm_convert_bash_to_zsh` 関数内に埋め込んで出力
8. zsh向けの終端コード（`__kubeadm_bash_source <(__kubeadm_convert_bash_to_zsh)`）を出力

## データベース更新仕様

### 操作別データベース影響一覧

本コマンドはデータの読み書きを一切行わない。シェル補完コードの生成と標準出力への出力のみ。

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| completion実行 | なし | なし | 補完コードの標準出力のみ |

## メッセージ仕様

| 種別 | メッセージ | 条件 |
|------|----------|------|
| エラー | `shell not specified` | シェル引数が指定されていない場合 |
| エラー | `too many arguments. expected only the shell type` | 引数が2つ以上指定された場合 |
| エラー | `unsupported shell type %q, the supported shell types are %v` | サポートされていないシェルが指定された場合 |

## 例外処理

| 例外状況 | 処理内容 |
|---------|---------|
| シェル引数なし | `shell not specified` エラーを返却 |
| 引数が2つ以上 | `too many arguments. expected only the shell type` エラーを返却 |
| サポート外のシェル指定 | `unsupported shell type` エラーを返却。サポートされるシェル一覧を提示 |
| ボイラープレート出力エラー | 書き込みエラーをそのまま返却 |

## 備考

- サポートされるシェルはbashとzshの2種類のみ（fish, powershell等はkubeadmでは未サポート。kubectlでは対応している）
- zsh補完は bash補完コードをzsh互換レイヤーで変換する方式を採用（zsh >= 5.2が必要）
- macOSでbash補完を使用する場合は `bash-completion` パッケージのインストールが必要（`brew install bash-completion`）
- Linux環境ではディストリビューションのパッケージマネージャーで `bash-completion` パッケージをインストールする必要がある
- ボイラープレートが空の場合はデフォルトのApache License 2.0ヘッダーが使用される
- 補完コードは `cmd.Parent()`（kubeadmルートコマンド）を対象として生成される

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

補完コード生成に使用されるデータ構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | completion.go | `cmd/kubeadm/app/cmd/completion.go` | `completionShells` マップ（86-89行目）: シェル名と対応する生成関数のマッピング。bash -> `runCompletionBash`, zsh -> `runCompletionZsh` |
| 1-2 | completion.go | `cmd/kubeadm/app/cmd/completion.go` | `defaultBoilerPlate` 定数（31-45行目）: 出力先頭に挿入されるApache License 2.0ヘッダー |

**読解のコツ**: `completionShells` マップがシェル種別の解決と対応する生成関数のディスパッチに使用される。

#### Step 2: エントリーポイントを理解する

コマンドの定義と実行フローを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | completion.go | `cmd/kubeadm/app/cmd/completion.go` | `newCmdCompletion()` 関数（102-115行目）: コマンド定義。`ValidArgs` に `GetSupportedShells()` の結果を設定 |
| 2-2 | completion.go | `cmd/kubeadm/app/cmd/completion.go` | `RunCompletion()` 関数（118-136行目）: 引数検証、シェル関数のルックアップ、ボイラープレート出力、補完コード生成 |

**主要処理フロー**:
1. **119-123行目**: 引数の数を検証（0個 or 2個以上でエラー）
2. **124-127行目**: `completionShells` マップから対応する関数を取得（見つからない場合はエラー）
3. **129-134行目**: ボイラープレートを出力
4. **135行目**: `run(out, cmd.Parent())` で補完コード生成を実行

#### Step 3: bash補完コード生成を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | completion.go | `cmd/kubeadm/app/cmd/completion.go` | `runCompletionBash()` 関数（138-141行目）: cobraの `GenBashCompletion()` メソッドを直接呼び出し |

#### Step 4: zsh補完コード生成を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | completion.go | `cmd/kubeadm/app/cmd/completion.go` | `runCompletionZsh()` 関数（143-301行目）: zsh互換レイヤーの出力、bash補完コードの生成、変換スクリプトの埋め込み |

**主要処理フロー**:
- **144-283行目**: `zshInitialization` 変数: bash互換関数群（`__kubeadm_bash_source`, `__kubeadm_type`, `__kubeadm_compgen`, `__kubeadm_compopt`, `__kubeadm_ltrim_colon_completions`, `__kubeadm_get_comp_words_by_ref`, `__kubeadm_filedir`, `__kubeadm_quote`）と `__kubeadm_convert_bash_to_zsh` 関数の定義
- **286行目**: zsh初期化コードを出力
- **288-291行目**: bash補完コードをバッファに生成し出力
- **293-299行目**: zsh終端コード（`__kubeadm_bash_source` の呼び出し）を出力

### プログラム呼び出し階層図

```
kubeadm completion SHELL
    |
    +-- newCmdCompletion() [completion.go:102]
            |
            +-- RunCompletion() [completion.go:118]
                    |
                    +-- (引数検証: 0個/2+個 -> エラー)
                    +-- completionShells[args[0]] (関数ルックアップ)
                    +-- out.Write(boilerPlate) (ライセンスヘッダー出力)
                    |
                    +-- (bash) runCompletionBash() [completion.go:138]
                    |       |
                    |       +-- kubeadm.GenBashCompletion(out) [cobra]
                    |
                    +-- (zsh) runCompletionZsh() [completion.go:143]
                            |
                            +-- out.Write(zshInitialization) [zsh互換レイヤー]
                            +-- kubeadm.GenBashCompletion(buf) [bash補完生成]
                            +-- out.Write(buf.Bytes()) [bash補完コード出力]
                            +-- out.Write(zshTail) [zsh終端コード]
```

### データフロー図

```
[入力]                  [処理]                              [出力]

SHELL引数 ─────> RunCompletion()
(bash/zsh)        |
                  +-- 引数検証
                  |
                  +-- ボイラープレート出力 ──────────────> stdout (ライセンスヘッダー)
                  |
                  +-- (bash) GenBashCompletion() ──────> stdout (bash補完コード)
                  |
                  +-- (zsh) zshInitialization ─────────> stdout (zsh互換レイヤー)
                  |         GenBashCompletion(buf) ───> stdout (bash補完コード)
                  |         zshTail ──────────────────> stdout (zsh終端コード)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| completion.go | `cmd/kubeadm/app/cmd/completion.go` | ソース | コマンド定義・bash/zsh補完コード生成ロジック |
| errors/ | `cmd/kubeadm/app/util/errors/` | ソース | エラーラッピングユーティリティ |
| cobra | `github.com/spf13/cobra` | 外部ライブラリ | GenBashCompletion()メソッドの提供元 |
| dedent | `github.com/lithammer/dedent` | 外部ライブラリ | ヘルプテキストのインデント除去 |
